class Respawnables_Pickup_Shield extends Respawnables_Pickup;

auto state Pickup
{	
	function Touch( actor Other )
	{
		if ( ValidTouch(Other) && Other == Fragger ) 
			{
			if ( !Respawnables_PRI(Pawn(Other).PlayerReplicationInfo).bHasShield )
				{
				Respawnables_PRI(Pawn(Other).PlayerReplicationInfo).bHasShield = True;
				Respawnables_PRI(Pawn(Other).PlayerReplicationInfo).NumItems += 1;
				PlayPickupMessage(PlayerPawn(Other));
				PlaySound(PickupSound,,2.5);
				Other.MakeNoise(0.2);		
				SetRespawn();
				}
			else
				{
				SetRespawn();
				}
			}
	}
}


defaultproperties
{
LifeTime=60
DrawType=DT_Sprite
CollisionRadius=32.00000
CollisionHeight=32.00000
Texture=Texture'reShield'
PickupMessage="Damage taken reduced by 50%!"
ItemName="Shield"
RespawnTime=0.000000
PickupSound=Sound'BotPack.Pickups.ArmorUT'
ScaleGlow=2.000000
bCollideWhenPlacing=True
RespawnTime=0
DrawScale=0.25
bIsAnArmor=True
bDisplayableInv=True
}
